package edu.uky.ai.lp;

import javax.swing.UIManager;

import edu.uky.ai.lp.ai.*;
import edu.uky.ai.lp.gui.Images;
import edu.uky.ai.lp.gui.WumpusFrame;

/**
 * Starts a new game of "Hunt the Wumpus".
 * 
 * @author Stephen G. Ware
 */
public class Main {

	/**
	 * Starts the game.
	 * 
	 * @param args ignored
	 * @throws Exception if an exception occurs during play
	 */
	public static void main(String[] args) throws Exception {
		Images.load();
		try { UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName()); }
		catch(Exception ex) { /* do nothing */ }
		Game game = new Game(new String[]{
				null, null, "GD", "PT",
				"WM", null, null, null,
				null, null, null, null,
				"PL", null, "PT", null
			});
		WumpusFrame frame = new WumpusFrame(game);
		Agent agent = new LogicAgent(); //new HumanAgent(frame.console);
		while(!game.over()) {
			Action action = agent.chooseAction(game);
			if(action == null) {
				System.out.println("The agent can't decide what to do next.");
				break;
			}
			Result result = game.act(action);
			frame.repaint();
			agent.observe(result);
		}
		frame.console.setEditable(false);
	}
}
